//
//		Definition of the main game class
//
#ifndef THE_GAME_H
#define THE_GAME_H


#include "ldwGame.h"

class theGameState;
class theMainScene;
class theMenuScene;
class theVillagerScene;
class theCollectionsScene;
class theOverviewScene;
class theSplashScene;
class theLoadingScene;
class ldwFont;
class ldwGameWindow;
class theHelpScene;

class theGame : public ldwGame
{
public:

	theGame();
	~theGame();

	bool Init();
	void Shutdown();

	void GameUpdate();
	void GameDraw();

	bool HandleMessage(int messageId,long data);
	bool ArmadilloCheckIfRegistered(void) ;

private:

	theGameState			*gs;
	theMenuScene			*menuScene;
	theVillagerScene	    *villagerScene;
	theOverviewScene		*overviewScene;
	theSplashScene			*splashScene;
	theHelpScene			*helpScene;
	theLoadingScene			*loadingScene;

	ldwGameWindow			*gameWindow;

	ldwFont *defaultFont;
	ldwFont *clearFont;

	int loadingProgress;

};
#endif